from simple_list import SimpleList
class IntList(SimpleList):
    def __init__(self, items=()):
        for x in items: 
            self._validate(x)
        super().__init__(items)

    @staticmethod
    def _validate(x):
        if not isinstance(x, int):
            raise TypeError('IntList only supports integer values.')

    def add(self, item): 
        self._validate(item) 
        super().add(item)

    def __repr__(self):
        return "IntList({!r})".format(list(self))
